// // // // // // // // // // // // // // // //
//
//	Enemy Territory - Map.cc
//
//	created November 5th,97 by Andreas Warnke
//	modified April 21st,98 by Andreas Warnke
//



#include "Map.h"
#include "GlobalVariables.h"



// // // // // // // // // // // // // // // //
//
//	CanWalk
//

bool Map :: CanWalk ( unsigned int inFieldType )
{
	if (( ePlainMin <= inFieldType ) && ( inFieldType <= ePlainMax ))
		//	Plain.
		return true;
	if (( eForrestMin <= inFieldType ) && ( inFieldType <= eForrestMax ))
		//	Forrest.
		return true;
	if (( eMountainMin <= inFieldType ) && ( inFieldType <= eMountainMax ))
		//	Mountain.
		return true;
		
	//	something else.
	return false;
};



// // // // // // // // // // // // // // // //
//
//	IsShiftRight
//	This function returns 1, if the row-parameter
//	is the number of a row that is shifted right on the map,
//	it returns 0, when it's at a normal position
//

int Map :: IsShiftRight ( int inRow )
{
	//	inRow gerade ?
	return ( ( inRow & 1 ) == 0 );
};



// // // // // // // // // // // // // // // //
//
//	Distance
//

unsigned int Map :: Distance ( int inX1, int inY1, int inX2, int inY2)
{
	//	scale of x-coordinates:
	inX1 = inX1 * 2 + IsShiftRight ( inY1 );
	inX2 = inX2 * 2 + IsShiftRight ( inY2 );
	
	//	Picture:
	//	[]  []  []  []  [] ...
	//	  []  []  []  []  [] ...
	//	[]  []  []  []  [] ...
	//	 :
	//	 :
	
	//	X-Distance:
	int dx;
	if ( inX1 < inX2 )
		dx = inX2 - inX1;
	else
		dx = inX1 - inX2;
		
	//	Y-Distance:
	int dy;
	if ( inY1 < inY2 )
		dy = inY2 - inY1;
	else
		dy = inY1 - inY2;
		
	//	subtract Y-Distance from X-Distance.
	//	dx is an even number.
	dx = dx - dy;
	
	if ( dx < 0 )
		//	only y-distance is interesting:
		return dy;
	else
		//	x- and y-distances are relevant.
		return dy + ( dx / 2 );
};



// // // // // // // // // // // // // // // // // // // //
//	
//	MoveToDirection
//

void Map :: MoveToDirection (
	int inX, int inY,
	int inDir,
	int & outX, int & outY )
{
	switch ( inDir % 6 )
	{
	case 0:	//	1 h
		outY = inY - 1;
		outX = inX + IsShiftRight ( inY );
		break;
	case 1:	//	3 h
		outX = inX + 1;
		outY = inY;
		break;
	case 2:	//	5 h
		outY = inY + 1;
		outX = inX + IsShiftRight ( inY );
		break;
	case 3:	//	7 h
		outY = inY + 1;
		outX = inX - 1 + IsShiftRight ( inY );
		break;
	case 4:	//	9 h
		outX = inX - 1;
		outY = inY;
		break;
	case 5:	//	11 h
		outY = inY - 1;
		outX = inX - 1 + IsShiftRight ( inY );
		break;
	};
};



//
//	The End.
//
// // // // // // // // // // // // // // // //


